# 画面設計書 3-Simple Ticker (Event版)

## 概要

本ドキュメントは、VBCorLibプロジェクトのサンプルアプリケーション「Simple Ticker (Event版)」の画面設計書です。

### 本画面の処理概要

Simple Ticker (Event版)は、VBCorLibライブラリが提供するTickerオブジェクトのイベント通知機能をデモンストレーションする画面です。Tickerは指定したインターバルで定期的にイベントを発火するタイマー機能を提供し、本画面ではそのイベントを受け取ってカウンターを更新する仕組みを示しています。

**業務上の目的・背景**：VB6/VBAで定期的な処理を実行する場合、標準のTimerコントロールに代わる方法として、VBCorLibのTickerオブジェクトが利用できます。本画面は、Tickerオブジェクトの基本的な使用方法とイベント駆動型の実装パターンを開発者に示すことを目的としています。WithEventsキーワードを使用した典型的なVBイベントハンドリングの例として参考になります。

**画面へのアクセス方法**：Examples/Misc/SimpleTicker/SimpleTicker.vbpプロジェクトを開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. Delayテキストボックスにインターバル（ミリ秒）を入力
2. 「Start Ticker」ボタンでタイマー開始
3. 「Stop Ticker」ボタンでタイマー停止
4. 「Reset Count」ボタンでカウンターリセット
5. Ticker.Elapsedイベント発火ごとにカウンター加算

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移はありません。

**権限による表示制御**：本画面は開発者向けデモツールであり、特別な権限制御は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 93 | Ticker | 主機能 | Tickerオブジェクトのイベント通知機能デモ（タイマー開始、停止、インターバル設定、Elapsedイベント） |

## 画面種別

デモンストレーション / タイマー制御

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Examples/Misc/SimpleTicker/Form1.frm`

## 入出力項目

| 項目名 | コントロール | 項目種別 | データ型 | 説明 |
|--------|-------------|----------|----------|------|
| Text1 | TextBox | 入力 | String | インターバル（ミリ秒）。初期値100 |
| Text2 | TextBox | 出力 | String | カウント表示（Locked=True） |

## 表示項目

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| Label1 | Label | String | "Delay:" ラベル |
| Label2 | Label | String | "Count:" ラベル |
| Text2 | TextBox | String | 現在のカウント値 |

## イベント仕様

### 1-Form_Load

フォーム読み込み時にTickerとCounterオブジェクトを初期化します。

**処理内容**:
1. Counterオブジェクトを作成（New Counter）
2. NewTicker関数でTickerオブジェクトを作成（インターバル100ms、データとしてCounterを渡す）

**コード参照**: 行114-119

```vb
Private Sub Form_Load()
    Set mCounter = New Counter
    Set mTicker = NewTicker(100, mCounter)
End Sub
```

### 2-cmdStartTicker_Click

タイマーを開始します。

**処理内容**:
1. Text1の値をTickerのIntervalに設定
2. Tickerが停止中であればStartTickerを呼び出し

**コード参照**: 行95-108

```vb
Private Sub cmdStartTicker_Click()
    mTicker.Interval = Text1.Text
    If Not mTicker.Enabled Then mTicker.StartTicker
End Sub
```

### 3-cmdStopTicker_Click

タイマーを停止します。

**処理内容**:
1. mTicker.StopTickerを呼び出してタイマー停止

**コード参照**: 行110-112

### 4-cmdResetCount_Click

カウンターをリセットします。

**処理内容**:
1. mCounter.Countを0に設定

**コード参照**: 行91-93

### 5-mTicker_Elapsed

Tickerのイベントハンドラ。インターバルごとに呼び出されます。

**処理内容**:
1. mCounter.Countを1加算
2. Counterオブジェクトが内部でChangedイベントを発火

**コード参照**: 行126-130

```vb
Private Sub mTicker_Elapsed(Data As Variant)
    mCounter.Count = mCounter.Count + 1
End Sub
```

### 6-mCounter_Changed

Counterオブジェクトのイベントハンドラ。Count変更時に呼び出されます。

**処理内容**:
1. Text2にカウント値を表示

**コード参照**: 行121-123

## データベース更新仕様

本画面はデータベースを使用しません。

## メッセージ仕様

本画面にメッセージ表示機能はありません。

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| 無効なインターバル値 | 数値以外の入力時はVBランタイムエラー発生 |

## 備考

- BorderStyle = Fixed Single（サイズ変更不可）
- MaxButton = False, MinButton = False（最大化・最小化ボタン無効）
- WithEventsキーワードでTickerとCounterのイベントを受け取る
- TickerオブジェクトにCounterオブジェクトをDataとして渡し、イベントハンドラ内で使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベント通知パターンで使用される2つのオブジェクトを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行85-89: WithEventsによる変数宣言 |

**読解のコツ**: VB6のWithEventsキーワードは、オブジェクトからのイベントを受け取るための宣言です。これによりmTicker_Elapsed、mCounter_Changedのようなイベントプロシージャが使用可能になります。

```vb
Private WithEvents mTicker As Ticker
Private WithEvents mCounter As Counter
```

#### Step 2: エントリーポイントを理解する

フォーム読み込み時の初期化処理がエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行114-119: Form_Load |

**主要処理フロー**:
1. **行115**: Counter オブジェクトを生成
2. **行118**: NewTicker関数でTickerオブジェクトを生成（インターバル100ms、Counterを渡す）

#### Step 3: タイマー制御フローを理解する

ボタン操作によるタイマー制御を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行95-108: cmdStartTicker_Click |
| 3-2 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行110-112: cmdStopTicker_Click |
| 3-3 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行91-93: cmdResetCount_Click |

**主要処理フロー（Start）**:
- **行102**: mTicker.Interval = Text1.Text でインターバル設定
- **行107**: If Not mTicker.Enabled Then mTicker.StartTicker

#### Step 4: イベントハンドリングを理解する

イベント発火時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行126-130: mTicker_Elapsed イベントハンドラ |
| 4-2 | Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | 行121-123: mCounter_Changed イベントハンドラ |

**主要処理フロー**:
- **行129**: Tickerイベント発火 → mCounter.Count加算
- **行122**: Counter変更 → Text2.Textに表示

### プログラム呼び出し階層図

```
Form_Load
    │
    ├─ New Counter
    │
    └─ NewTicker(100, mCounter)

cmdStartTicker_Click
    │
    ├─ mTicker.Interval = Text1.Text
    │
    └─ mTicker.StartTicker

cmdStopTicker_Click
    │
    └─ mTicker.StopTicker

cmdResetCount_Click
    │
    └─ mCounter.Count = 0
           │
           └─ [イベント発火] mCounter_Changed
                  │
                  └─ Text2.Text = mCounter.Count

[タイマー発火]
    │
    └─ mTicker_Elapsed(Data)
           │
           └─ mCounter.Count = mCounter.Count + 1
                  │
                  └─ [イベント発火] mCounter_Changed
                         │
                         └─ Text2.Text = mCounter.Count
```

### データフロー図

```
[入力]               [処理]                    [出力]

Text1 (Delay) ───▶ mTicker.Interval ─────────▶ タイマー設定

                    [タイマー発火]
                          │
                          ▼
                    mTicker_Elapsed
                          │
                          ▼
                    mCounter.Count++
                          │
                          ▼
                    mCounter_Changed
                          │
                          ▼
                    Text2.Text ──────────────▶ カウント表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/Misc/SimpleTicker/Form1.frm` | ソース | メインフォーム |
| Counter.cls | `Examples/Misc/SimpleTicker/Counter.cls` | ソース | カウンタークラス（Changedイベント発火） |
| SimpleTicker.vbp | `Examples/Misc/SimpleTicker/SimpleTicker.vbp` | プロジェクト | プロジェクト定義 |
| VBCorLib.dll | 外部 | DLL | VBCorLibライブラリ本体（Ticker提供） |
